-- ************************************
-- VX_sp_UpdateCallBackExtendedRules
-- ************************************
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_UpdateCallBackExtendedRules]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[VX_sp_UpdateCallBackExtendedRules]
GO


CREATE PROCEDURE [dbo].[VX_sp_UpdateCallBackExtendedRules]
@NewExtendedRules xml
AS
BEGIN
 SET NOCOUNT ON;
 SELECT 
     colx.value('Id[1]','int') as Id 
  ,colx.value('ExtNumber[1]','int') as ExtNumber
  ,colx.value('ExtNewResult[1]','varchar(2)') as ExtNewResult
  ,colx.value('ExtLifeState[1]','varchar(3900)') as ExtLifeState
  ,colx.value('ExtResultsSequence[1]','varchar(4000)')  as ExtResultsSequence
  ,colx.value('ExtCallback[1]','bit') as ExtCallback
  ,colx.value('ExtInterviewer[1]','varchar(10)')      as ExtInterviewer
  ,colx.value('ExtDelay[1]','int') as ExtDelay
  ,colx.value('ExtUnit[1]','int') as ExtUnit
  ,colx.value('ExtPriority[1]','int') as ExtPriority
  ,colx.value('ExtPriorityType[1]','int') as ExtPriorityType
  ,colx.value('DialingMode[1]','int') as DialingMode
  ,colx.value('ExtWaveInc[1]','bit') as ExtWaveInc
  ,colx.value('projectId[1]','int') as projectid
  ,colx.value('modifiedBy[1]','int') as modifiedBy
  ,colx.value('xs:dateTime(modified[1])','datetime') as modified    
  ,colx.value('SynchResult[1]','int') as SynchResult    
  ,colx.value('RestrictionOverride[1]','bit') as RestrictionOverride
  ,colx.value('UploadToA4S[1]','bit') as UploadToA4S    
  ,colx.value('PhoneCyclingBehavior[1]','int') as PhoneCyclingBehavior
 INTO #TMP FROM @NewExtendedRules.nodes('NewDataSet/ExtendedRules') AS Tabx(Colx)
 update ExtendedRules set deleted = 1 
 from (
 select 
 Id,ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,ExtInterviewer,ExtDelay
 ,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,SynchResult,DialingMode,RestrictionOverride,UploadToA4S,PhoneCyclingBehavior
 from ExtendedRules where deleted = 0
 except
 select Id,ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,ExtInterviewer,ExtDelay
 ,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,SynchResult,DialingMode,RestrictionOverride,UploadToA4S,PhoneCyclingBehavior
 from #TMP 
 )b
 where deleted = 0  and ExtendedRules.Id = b.Id
     update ExtendedRules set ExtendedRules.modifiedBy = #TMP.modifiedBy ,ExtendedRules.modified = #TMP.modified from #TMP
   where ExtendedRules.deleted = 1 and #TMP.Id = ExtendedRules.Id 
 insert into ExtendedRules
 (ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,ExtInterviewer,ExtDelay
 ,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,projectId,modifiedBy,modified,SynchResult,DialingMode,RestrictionOverride,UploadToA4S,PhoneCyclingBehavior)
 select ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,isnull(ExtInterviewer,'') as ExtInterviewer,ExtDelay
 ,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,projectId,modifiedBy,modified,SynchResult,DialingMode,RestrictionOverride,IsNull(UploadToA4S, 0),IsNull(PhoneCyclingBehavior, 0)
 from #TMP where ExtNumber in (
 select ExtNumber from 
 (
 select ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,ExtInterviewer,ExtDelay
 ,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,SynchResult,DialingMode,RestrictionOverride,UploadToA4S,PhoneCyclingBehavior
 from #TMP 
 except
 select 
 ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,ExtInterviewer,ExtDelay
 ,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,SynchResult,DialingMode,RestrictionOverride,UploadToA4S,PhoneCyclingBehavior
 from ExtendedRules  where deleted = 0
 )b)
 DROP TABLE #TMP
END
